function Enemy()
{
	this.hp = 0;
	this.hpmax = 0;
	this.mp = 0;
	this.mpmax = 0;
	this.lv = 1;
	this.exp = 0;
	this.money = 0;
	// Attributes
	this.strength = 0;
	this.endurance = 0;
	this.magic = 0;
	this.will = 0;
	this.agility = 0;
	this.luck = 0;
	// Statistics
	this.attack = 10;
	this.defense = 10;
	this.hit = 100;
	this.evade = 10;
	this.mdefense = 10;
	this.mevade = 10;
	// Resistance and Status
	this.element = Elements();
	this.status = Status();
	this.weapon = natural;
	// Battle stuff
	this.ct = 0;
	this.damage = undefined;
}

Enemy.prototype.load = function(name)
{
	this.name = name;
	this.sprite = new Sprite(name + ".rss");
	this.sprite.loop = true;
	var file = OpenFile("enemy.dat");
	var heading = name+":";
	this.hp = file.read(heading+"HP", 0);
	this.hpmax = this.hp;
	this.mp = file.read(heading+"MP", 0);
	this.mpmax = this.mp;
	this.lv = file.read(heading+"Lv", 1);
	this.exp = file.read(heading+"Exp", 0);
	this.money = file.read(heading+"Money", 0);
	this.strength = file.read(heading+"Strength", 0);
	this.endurance = file.read(heading+"Endurance", 0);
	this.magic = file.read(heading+"Magic", 0);
	this.will = file.read(heading+"Will", 0);
	this.agility = file.read(heading+"Agility", 0);
	this.luck = file.read(heading+"Luck", 0);
}

Enemy.prototype.clone = function()
{
	var enemy = new Enemy();
	enemy.name = this.name;
	enemy.sprite = this.sprite;
	enemy.hp = this.hp;
	enemy.hpmax = this.hpmax;
	enemy.mp = this.mp;
	enemy.mpmax = this.mpmax;
	enemy.lv = this.lv;
	enemy.exp = this.exp;
	enemy.money = this.money;
	enemy.strength = this.strength;
	enemy.endurance = this.endurance;
	enemy.magic = this.magic;
	enemy.will = this.will;
	enemy.agility = this.agility;
	enemy.luck = this.luck;
	enemy.attack = this.attack;
	enemy.defense = this.defense;
	enemy.hit = this.hit;
	enemy.evade = this.evade;
	enemy.mdefense = this.mdefense;
	enemy.mevade= this.mevade;
	enemy.element = this.element;
	enemy.status = this.status;
	enemy.ct = this.ct;
	enemy.damage = this.damage;
	return enemy;
}

Enemy.prototype.turn = function()
{
	mainAttack(new Array(system.currentBattle.list[0]));
}

Enemy.prototype.battleDraw = function()
{
	this.sprite.draw(this.x, this.y);
}